/*!
*******************************************************************************
* \file             mspinVrStream.h
* \brief            Implements the Audio functionality for mySPIN
*******************************************************************************
\verbatim
PROJECT:        Gen3 Projects
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Audio Streaming (Lib) Implementation for mySPIN using gstreamer
COPYRIGHT:      &copy; BSOT

HISTORY:
Date       |  Author                          | Modifications
19.02.2016 |  J. Schmidt                      | initial version

\endverbatim
******************************************************************************/

#ifndef __MYSPINVRSTREAM_H__
#define __MYSPINVRSTREAM_H__

#include <adit-system/adit_typedef.h>

#include <functional>
#include "alsa/asoundlib.h"

//! \brief List of errors, that are passed to  MySpinVrStreamError callback function
typedef enum
{
    MYSPIN_VR_STREAM_ERROR_NOMEM = 1,
    // TBD: Expand
}vrStreamError;

//! \brief Definition of MySpinVrStreamError callback function
typedef std::function<void(U32, vrStreamError)> vOnMySpinVrStreamError;

//! \brief Structure holding the callback functions of spi_tclMySpinVrStream.
struct vrStreamCallbacks
{
    vOnMySpinVrStreamError fvOnMySpinVrStreamError;

    vrStreamCallbacks() :
        fvOnMySpinVrStreamError(NULL)
    {
    }
};

//! \brief Capture/Playback device specific configuration
typedef struct
{
    // ALSA name of device
    std::string deviceName;

    // Set to TRUE, when buffer and period size shall be set explicitly
    bool setBufferSizeAndPeriodSize;

    // Buffer size to set. Only used, when bSetBufferSizeAndPeriodSize == TRUE
    snd_pcm_uframes_t bufferSize;

    // Period size to set. Only used, when bSetBufferSizeAndPeriodSize == TRUE
    snd_pcm_uframes_t periodSize;

    // Set to TRUE, when read or write access shall block
    bool blocking; //TBD: Blocking mode is currently unused and untested - Remove?

}vrDeviceConfig;

class spi_tclMySpinVrStream;

class MySpinVrStream
{

public:
    MySpinVrStream();

    virtual ~MySpinVrStream();

    virtual S32 startVrStream(const vrDeviceConfig captureDeviceConfig,
                                 const vrDeviceConfig playbackDeviceConfig,
                                 const snd_pcm_access_t spaAccess,
                                 const snd_pcm_format_t spfFormat,
                                 const unsigned int channels,
                                 const unsigned int samplerate);

    virtual S32 stopVrStream();

    virtual void registerCallbacks(U32 cou32Context , vrStreamCallbacks vrCallbacks);

private:

    spi_tclMySpinVrStream* m_poMySpinVrStream;
};


#endif /* __MYSPINVRSTREAM_H__ */
